package cn.quantgroup.customer.enums;

public enum ErrorCodeEnum {


    NET_ERROR(6001L, "网络通讯异常"),
    RETURN_ERROR(7001L, "返回值异常"),
    PARAM_ERROR(7002L, "参数异常"),
    NO_TOKEN(8001L,"缺少token信息"),
    ILLEGAL_TOKEN(8002L,"token信息有误"),
    PHONE_EQUALS(8003L, "新手机号已存在，不支持更换"),
    ;


    public String getMessage() {
        return message;
    }


    public Long getCode() {
        return code;
    }

    private Long code;
    private String message;

    ErrorCodeEnum(Long code, String message) {
        this.code = code;
        this.message = message;
    }


}
