package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.rest.vo.JsonResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import static org.springframework.http.HttpStatus.*;

@Slf4j
@RestController
@RequestMapping("/error")
public class ErrorRest {

    @RequestMapping("/500")
    public JsonResult internalServerError() {
        return JsonResult.buildErrorStateResult(INTERNAL_SERVER_ERROR.getReasonPhrase(), Long.valueOf(INTERNAL_SERVER_ERROR.toString()));
    }

    @RequestMapping("/403")
    public JsonResult forbidden() {
        return JsonResult.buildErrorStateResult(FORBIDDEN.getReasonPhrase(), Long.valueOf(FORBIDDEN.toString()));
    }

    @RequestMapping("/400")
    public JsonResult badRequest() {
        return JsonResult.buildErrorStateResult(BAD_REQUEST.getReasonPhrase(), Long.valueOf(BAD_REQUEST.toString()));
    }

}
