package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.entity.User;
import cn.quantgroup.customer.rest.param.LoginParam;
import cn.quantgroup.customer.rest.vo.SimpleUserVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;

import static cn.quantgroup.customer.constant.Constant.*;

@Slf4j
@RestController
public class UserRest {

    private final AuthenticationManager authenticationManager;

    public UserRest(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    @PostMapping(value = "/login")
    public JsonResult login(@Valid @ModelAttribute LoginParam loginParam, HttpServletRequest request) {
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken(loginParam.getUsername(), loginParam.getPassword());
        Authentication authentication = authenticationManager.authenticate(authRequest);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        HttpSession session = request.getSession();
        session.setAttribute(SPRING_SECURITY_CONTEXT, SecurityContextHolder.getContext());

        if (authentication != null && authentication.isAuthenticated()) {
            User principal = (User) authentication.getPrincipal();
            SimpleUserVo simpleUserVo = SimpleUserVo.parse(principal);
            return JsonResult.buildSuccessResult(LOGIN_SUCCESS, simpleUserVo);
        }
        return JsonResult.buildErrorStateResult(LOGIN_FAIL, null);
    }

    @PostMapping(value = "/logout")
    public JsonResult logout(@AuthenticationPrincipal User user) {
        return JsonResult.buildSuccessResult(LOGOUT_SUCCESS, null);
    }

    @GetMapping(value = "/logout-success")
    public JsonResult logoutSuccess() {
        return JsonResult.buildSuccessResult(LOGOUT_SUCCESS, null);
    }

}
