package cn.quantgroup.customer.model.order;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;


/**
 * @author yangjun
 * @Date 2020/3/20 14:13
 * @Desc
 * @Update
 */
@Data
public class CallbackRecord {
    /**
     * 通知类型
     */
    private String noticeType;
    /**
     * 通知成功或者失败
     */
    private String noticeStatus;
    /**
     * 期数
     */
    private Long termNo;
    /**
     * 通知时间
     */
    private Long dateTime;
    /**
     * 通知时间 YYYY-MM-dd HH:mm:ss
     */
    private String createAt;

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (Objects.isNull(obj)) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        CallbackRecord other = (CallbackRecord) obj;
        if (StringUtils.isBlank(other.getNoticeType())) {
            return false;
        } else {
            if(!this.getNoticeType().equals(other.getNoticeType())){
                return false;
            }else {
                if(Objects.isNull(other.getTermNo())){
                    return true;
                }else{
                    if(!this.getTermNo().equals(other.getTermNo())){
                        return false;
                    }
                    return true;
                }
            }
        }
    }
}
