package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.rest.param.ordermapping.EarlySettleUpOrderQueryParam;
import cn.quantgroup.customer.rest.param.ordermapping.OperateEntryParam;
import cn.quantgroup.customer.rest.param.ordermapping.OrderQueryParam;
import cn.quantgroup.customer.rest.param.repay.RepayOrderInfoQuery;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IOrderService;
import cn.quantgroup.customer.service.IXyqbService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * @author Wang Xiangwei
 * @version 2020/3/9
 */

@Slf4j
@RestController
@RequestMapping("/order")
public class OrderRest {



    @Autowired
    private IOrderService orderService;

    @GetMapping("/loan/{loanId}")
    public JsonResult getLoanOrderDetail(@PathVariable Long loanId){
        return orderService.getLoanOrderDetail(loanId);
    }

    @GetMapping("/flowchart/{orderNo}")
    public JsonResult getFlowChart(@PathVariable String orderNo){
        return orderService.findFlowChart(orderNo);
    }

    /**
     * 订单信息查询
     * @param orderQuery
     * @return
     */
    @GetMapping("/info")
    public JsonResult queryRepayInfo(OrderQueryParam orderQuery) {
        log.info("[查询订单信息],请求参数:orderQuery={}", orderQuery);
        return orderService.queryOrderInfo(orderQuery);
    }

    /**
     * 订单提前一次性结清查询
     * @param orderQuery
     * @return
     */
    @GetMapping("/queryEarlySettleUpOrders")
    public JsonResult queryEarlySettleUpOrders(EarlySettleUpOrderQueryParam orderQuery) {
        log.info("[订单提前一次性结清查询],请求参数:orderQuery={}", orderQuery);
        return orderService.queryEarlySettleUpOrders(orderQuery);
    }

    /**
     * 显示/隐藏结清入口操作
     * @param operateEntryParam
     * @return
     */
    @PostMapping("/operateEntry")
    public JsonResult operateEntry(OperateEntryParam operateEntryParam) {
        log.info("[显示/隐藏结清入口操作],请求参数:operateEntryParam={}", operateEntryParam);
        return orderService.operateEntry(operateEntryParam);
    }

    /**
     * 提前一次性结清金额试算
     * @param loanId
     * @return
     */
    @GetMapping("/earlySettleUpTrial/{loanId}")
    public JsonResult earlySettleUpTrial(@PathVariable Long loanId) {
        log.info("[提前一次性结清金额试算],请求参数:loanId={}", loanId);
        return orderService.earlySettleUpTrial(loanId);
    }

    /**
     * 操作日志查询
     * @param loanId
     * @return
     */
    @GetMapping("/queryOperateLog/{loanId}")
    public JsonResult queryOperateLog(@PathVariable Long loanId) {
        log.info("[操作日志查询],请求参数:loanId={}", loanId);
        return orderService.queryOperateLog(loanId);
    }
}
