package cn.quantgroup.customer.config.http.mvc.filter;

import cn.quantgroup.customer.config.container.UserThreadLocal;
import cn.quantgroup.customer.entity.OpUser;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IOpSystemService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Objects;

/**
 * @author yangjun
 * @Date 2020/4/16 9:46
 * @Desc
 * @Update
 */
@Slf4j
@Component
public class UserTokenInterceptor implements HandlerInterceptor{
    @Autowired
    private IOpSystemService IOpSystemService;



    @Override
    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        if (HttpMethod.OPTIONS.toString().equals(httpServletRequest.getMethod())) {
            log.info("OPTIONS请求，放行");
            return true;
        }

        String token = httpServletRequest.getHeader("x-auth-token");
        String system = httpServletRequest.getHeader("x-auth-system");
        if(StringUtils.isAnyBlank(token,system)){
            log.error("缺少token信息,拦截");
            return false;
        }

        JsonResult<OpUser> opUserResult= IOpSystemService.findUserByToken(token,system);
        if(Objects.isNull(opUserResult) || !opUserResult.isSuccess()){
            log.error("根据token查询不到用户信息 token:{}",token);
            return false;
        }else{
            OpUser opUser = opUserResult.getData();
            UserThreadLocal.set(opUser);
            return true;
        }

    }

    @Override
    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {

    }
}
