package cn.quantgroup.customer.enums;

import java.util.Arrays;
import java.util.Optional;

/**
 * 试算字段转换
 */
public enum OrderFieldEnum {
    PRINCIPAL("principal","应还本金"),
    INTEREST("interest","应还利息"),
    SERVICE_FEE("serviceFee","应还担保费"),
    PREMIUM("premium","应还保费"),
    OVERDUE_INTEREST("overDueInterest","应还罚息"),
    LIQUIDATE_DAMAGES("liquidatedDamages","结清违约金"),
    OTHERFEE("otherFee","应还其他费用"),
    TOTAL_AMOUNT("totalAmount","应还总额"),
    OTHER("other","其他收费项目");


    private String field;
    private String title;

    OrderFieldEnum(String field, String title) {
        this.field = field;
        this.title = title;
    }

    public String getField() {
        return field;
    }

    public String getTitle() {
        return title;
    }



    public static String getValue(String field){
        Optional<OrderFieldEnum> optional = Arrays.asList(OrderFieldEnum.values()).stream().filter(orderFieldEnum -> field.equalsIgnoreCase(orderFieldEnum.getField())).findFirst();
        if(optional.isPresent()){
            return optional.get().getTitle();
        }
        return OrderFieldEnum.OTHER.getTitle();
    }
}
