package cn.quantgroup.customer.service.impl;

import cn.quantgroup.customer.entity.OpLog;
import cn.quantgroup.customer.entity.OperateLogModel;
import cn.quantgroup.customer.repo.OperateLogRepo;
import cn.quantgroup.customer.service.IOperateLogService;
import cn.quantgroup.customer.util.JSONTools;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author yangjun
 * @Date 2020/4/15 12:00
 * @Desc
 * @Update
 */
@Service("operateLogService")
public class OperateLogServiceImpl implements IOperateLogService{
    @Autowired
    private OperateLogRepo operateLogRepo;

    @Override
    public void saveOperateLog(OperateLogModel logModel) {
        operateLogRepo.save(logModel);
    }

    @Override
    public List<OpLog> findLogsByLoanId(Long loanId) {
        List<OperateLogModel> list = operateLogRepo.findLogsByLoanId(loanId);
        List<OpLog> opLogs = new ArrayList<>(list.size());
        list.forEach(it ->
                opLogs.add(JSONObject.parseObject(JSONObject.toJSONString(it), OpLog.class)));
        return opLogs;
    }
}
