package cn.quantgroup.customer.service;

import java.io.IOException;
import java.io.InputStream;

/**
 * fastDFS 接入 http://confluence.quantgroup.cn/x/bMU5AQ
 *
 * @author jingfeng.guo
 * @since 2019-08-24 17:04
 */

public interface IFastDFSService {

    /**
     * 上传文件
     *
     * @param fileInput
     * @param fileSize
     * @param fileExtName 扩展名
     * @return
     * @throws IOException
     */
    String uploadFile(InputStream fileInput, Long fileSize, String fileExtName) throws IOException;

    /**
     * 上传文件
     *
     * @param bytes
     * @param fileExtName
     * @return
     * @throws IOException
     */
    String uploadFile(byte[] bytes, String fileExtName) throws IOException;

    /**
     * 文件上传, 下载url 再传
     *
     * @param url
     * @param fileExtName
     * @return
     * @throws IOException
     */
    String uploadFile(String url, String fileExtName) throws IOException;


    /**
     * 上传文件 base64
     *
     * @param base64String
     * @param fileExtName
     * @return
     * @throws IOException
     */
    String uploadFileOfBase64String(String base64String, String fileExtName) throws IOException;

    /**
     * 下载文件
     *
     * @param path
     * @return
     * @throws IOException
     */
    byte[] downloadFile(String path) throws IOException;

    /**
     * 转成一个临时可用的url
     *
     * @param path
     * @return
     * @throws IOException
     */
    String toUrl(String path) throws IOException;
}
