package cn.quantgroup.customer.service.ftp;

import cn.quantgroup.customer.model.ftp.FileInfo;
import cn.quantgroup.customer.model.ftp.ServerInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.Map;

/**
 * @author yexiong.wang
 * @date 2022/02/27
 */
@Slf4j
@Service("CustomerSftpServiceImpl")
public class CustomerSftpServiceImpl extends AbstractFtpService implements IFtpService {

    @Value("${customer.sftp.user}")
    private String username;
    @Value("${customer.sftp.password}")
    private String password;
    @Value("${customer.sftp.host}")
    private String host;
    @Value("${customer.sftp.directory}")
    private String directory;
    @Value("${customer.sftp.port}")
    private int port;

    /**
     * @param request   请求参数对象
     * @param retryTime 上传失败重试次数
     * @return ture:上传成功，false:上传失败
     * @throws Exception
     */
    @Override
    public Boolean send(Object request, int retryTime) throws Exception {
        String fileName = "";
        String path = "";
        byte[] fileBytes = null;
        if (request instanceof Map) {
            fileName = (String) ((Map) request).get("fileName");
            fileBytes = (byte[]) ((Map) request).get("fileBytes");
            path = (String) ((Map) request).get("filePath");
        }
        if (StringUtils.isBlank(fileName)) {
            throw new RuntimeException("文件名不能为空");
        }
        if (fileBytes == null) {
            throw new RuntimeException("文件内容不能为空");
        }
        log.info("客服系统上传sftp, fileName:{}, path:{}", fileName, path);
        FileInfo fileInfo = new FileInfo(fileName, fileBytes, path);
        ServerInfo serverInfo = ServerInfo.builder()
            .username(username)
            .directory(directory)
            .host(host)
            .password(password)
            .port(port)
            .build();
        send(fileInfo, serverInfo, 3);
        return null;
    }


    @Override
    public byte[] down(String fileName) throws IOException {
        ServerInfo serverInfo = ServerInfo.builder()
            .username(username).directory(directory)
            .host(host).password(password)
            .port(port)
            .build();

        byte[] result;
        try {
            fileName = directory.concat(fileName);
            result = down(fileName, serverInfo, 1);
        } catch (IOException ioEx) {
            log.warn("客服系统下载文件，出现异常，fileName:{}, ex:{}", fileName, ExceptionUtils.getStackTrace(ioEx));
            throw ioEx;
        }
        catch (Exception e) {
            log.warn("客服系统下载文件，出现异常，fileName:{}, ex:{}", fileName, ExceptionUtils.getStackTrace(e));
            throw new IOException("下载未知异常");
        }
        if (result == null) {
            throw new IOException("文件为空");
        }
        return result;
    }


}
