package cn.quantgroup.customer.entity;

import cn.quantgroup.customer.model.workorder.WorkOrderStatus;
import cn.quantgroup.customer.model.workorder.WorlOrderPriority;
import lombok.*;

import javax.persistence.*;
import java.sql.Timestamp;

/**
 * @author yangjun
 * @Date 2020/4/13 17:37
 * @Desc
 * @Update
 */
@Entity
@Table(name = "work_order")
@ToString
@Builder
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class WorkOrder {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "work_order_id")
    private Long workOrderId;

    @Column(name = "user_name")
    private String userName;

    @Column(name = "phone")
    private String phone;

    @Column(name = "subject")
    private String subject;

    @Column(name = "from_channel")
    private String from;

    @Column(name = "type1")
    private String type1;

    @Column(name = "type2")
    private String type2;

    @Column(name = "type3")
    private String type3;

    /**
     * 优先级
     */
    @Column(name = "priority")
    private WorlOrderPriority priority;

    /**
     * 状态
     */
    @Column(name = "status")
    private WorkOrderStatus status;

    @Column(name = "create_username")
    private String createUsername;

    @Column(name = "op_username")
    private String opUsername;

    /**
     * 流转次数
     */
    @Column(name = "duration_times")
    private Integer durationTimes;

    /**
     * 流转时长
     */
    @Column(name = "duration")
    private Integer duration;

    @Column(name = "created_at")
    private Timestamp createdAt;

    @Column(name = "op_at")
    private Timestamp opAt;

    @Column(name = "updated_at")
    private Timestamp updatedAt;

    @Column(name = "remark")
    private String remark;


}
