package cn.quantgroup.third.customer.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Entity
@Table(name = "lhpds_sys_user")
@ToString
@Builder
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class LhpdsSysUser {
  @Id
  @Column(name = "id")
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  // 用户编号
  private Long id;

  // 用户帐号
  @Column(name = "account_id")
  private String accountId;

  // 用户昵称(在线字段)
  @Column(name = "nickname")
  private String nickname;

  // 用户姓名
  @Column(name = "username")
  private String username;

  // 用户密码
  @Column(name = "password")
  private String password;

  // 盐值
  @Column(name = "salt")
  private String salt;

  // 用户类型(1-普通用户 2-在线用户 3-坐席用户 4-在线+坐席)
  @Column(name = "user_type")
  private Integer userType;

  // 用户等级(在线字段 取值1-5)
  @Column(name = "level")
  private Integer level;

  // 创建时间
  @Column(name = "create_time")
  private Date createTime;

  // 创建人员
  @Column(name = "create_user")
  private String createUser;

  // 更新时间
  @Column(name = "update_time")
  private Date updateTime;

  // 更新人员
  @Column(name = "update_user")
  private String updateUser;

  // 是否首次登录(默认为0 0-首次登录 1-不是首次登录)
  @Column(name = "is_first_login")
  private Integer isFirstLogin;

  // 错误密码次数(默认值为0)
  @Column(name = "login_fail_count")
  private Integer loginFailCount;

  // 登录超限锁定时间
  @Column(name = "login_locking_time")
  private Date loginLockingTime;

  // 最大同时会话量(在线字段 取值0-100)
  @Column(name = "max_current_session_count")
  private Integer maxCurrentSessionCount;

  // 状态(默认为0，0-启用 1-禁用 2-删除)
  @Column(name = "status")
  private Integer status;

  // 预留字段01
  @Column(name = "field01")
  private String field01;

  // 预留字段02
  @Column(name = "field02")
  private String field02;

  // 预留字段03
  @Column(name = "field03")
  private String field03;

  // 预留字段04
  @Column(name = "field04")
  private String field04;

  // 预留字段05
  @Column(name = "field05")
  private String field05;

  // 预留字段06
  @Column(name = "field06")
  private String field06;

  // 预留字段07
  @Column(name = "field07")
  private String field07;

  // 预留字段08
  @Column(name = "field08")
  private String field08;

  // 预留字段09
  @Column(name = "field09")
  private String field09;

  // 预留字段10
  @Column(name = "field10")
  private String field10;

  // 预留字段11
  @Column(name = "field11")
  private String field11;

  // 预留字段12
  @Column(name = "field12")
  private String field12;

  // 预留字段13
  @Column(name = "field13")
  private String field13;

  // 预留字段14
  @Column(name = "field14")
  private String field14;

  // 预留字段15
  @Column(name = "field15")
  private String field15;

  // 预留字段16
  @Column(name = "field16")
  private String field16;

  // 预留字段17
  @Column(name = "field17")
  private String field17;

  // 预留字段18
  @Column(name = "field18")
  private String field18;

  // 预留字段19
  @Column(name = "field19")
  private String field19;

  // 预留字段20
  @Column(name = "field20")
  private String field20;

}
