package cn.quantgroup.customer.rest.vo.repay;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * @author yangjun
 * @Date 2020/3/10 12:36
 * @Desc
 * @Update
 */
@Data
@ToString
@AllArgsConstructor
@NoArgsConstructor
public class RepayOptRecord {
    /**
     * 操作时间
     */

    String operationTime;

    /**
     * 操作类型
     * TODO
     */
    Integer type;

    /**
     * 操作类型描述
     */
    String typeDesc;

    /**
     * 业务类型 0：提现，1：还款，2 绑卡
     */
    Integer optionType;

    /**
     * 支付渠道名称
     */
    String payApproachName;

    /**
     * 商编号
     */
    String accountNo;

    /**
     * 卡号
     */
    String cardNo;

    /**
     * 预留手机号
     */
    String phoneNo;

    /**
     * 0：失败， 1：成功，2：超时
     */
    Integer status;

    /**
     * 短信发送方式
     */
    String sendSms;

    /**
     * 错误描述
     */
    String errorMsg;
}
