package cn.quantgroup.customer.service.impl;

import cn.quantgroup.customer.enums.ErrorCodeEnum;
import cn.quantgroup.customer.exception.BusinessException;
import cn.quantgroup.customer.model.kaordermapping.LoanOrderMapping;
import cn.quantgroup.customer.rest.param.ordermapping.OrderMappingQueryParam;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IKaService;
import cn.quantgroup.customer.service.http.IHttpService;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;

import static cn.quantgroup.customer.constant.Constant.GSON;

/**
 * @author Wang Xiangwei
 * @version 2020/3/9
 */
@Slf4j
@Service
public class KaServiceImpl implements IKaService {


    @Value("${ka.api.http}")
    private String kaSysUrl;

    @Autowired
    private  IHttpService httpService;
    @Override
    public JsonResult<LoanOrderMapping> findOrderMapping(OrderMappingQueryParam orderMappingQueryParam) {
        String logPre = "KaServiceImpl.findOrderMapping";
        log.info("{},获得orderMapping orderMappingQueryParam={}",logPre,orderMappingQueryParam);

        if(Objects.isNull(orderMappingQueryParam)){
            log.error("{} 查询参数为空 orderMappingQueryParam={}",logPre,orderMappingQueryParam);
            return JsonResult.buildErrorStateResult("查询参数为空",null);
        }

        String applyOrderNo = orderMappingQueryParam.getApplyOrderNo();
        String channelOrderNo = orderMappingQueryParam.getChannelOrderNo();
        Long loanId = orderMappingQueryParam.getLoanId();


        String url = kaSysUrl + "/api/order_mapping/get";
        try {
            Map<String, Object> param = Maps.newHashMap();
            if(!Objects.isNull(applyOrderNo)){
                param.put("applyOrderNo", applyOrderNo);

            }
            if(StringUtils.isNotBlank(channelOrderNo)){
                param.put("channelOrderNo", channelOrderNo);

            }
            if(StringUtils.isNotBlank(channelOrderNo)){
                param.put("loanId", loanId);
            }

            String result = httpService.get(url, param);
            log.info("{} 请求ka系统返回值:{}",logPre, result);
            JsonResult jsonResult = GSON.fromJson(result, JsonResult.class);
            if(Objects.isNull(jsonResult) || !jsonResult.isSuccess()){
                log.error("{} 查询orderMapping失败 jsonResult={}",logPre,jsonResult);
                return JsonResult.buildErrorStateResult("查询orderMapping失败",null);
            }

            Object data = jsonResult.getData();
            LoanOrderMapping loanOrderMapping = GSON.fromJson(data.toString(), LoanOrderMapping.class);
            jsonResult.setData(loanOrderMapping);
            return jsonResult;


        } catch (Exception e) {
            log.error("{} 网络通讯异常,orderMappingQueryParam:{},ex:{}", orderMappingQueryParam, ExceptionUtils.getStackTrace(e));
            throw new BusinessException(ErrorCodeEnum.NET_ERROR);
        }

    }
}
