package cn.quantgroup.customer.entity;

import cn.quantgroup.customer.enums.AuthorityEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.security.core.GrantedAuthority;

import javax.persistence.*;
import java.util.Objects;

@Entity
@Table(name = "authorities")
@Getter
@Setter
@ToString
public class Authority implements GrantedAuthority {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "authority")
    private AuthorityEnum authority;

    @Override
    public String getAuthority() {
        if (Objects.isNull(authority)) {
            return null;
        }
        return authority.getName();
    }

    public String getAuthorityMessage() {
        if (Objects.isNull(authority)) {
            return null;
        }
        return authority.getMessage();
    }


}
