package cn.quantgroup.customer.config.http.mvc;

import cn.quantgroup.customer.config.http.mvc.converter.DateConverter;
import cn.quantgroup.customer.config.http.mvc.converter.IEnumConverterFactory;
import cn.quantgroup.customer.config.http.mvc.converter.LocalDateConverter;
import cn.quantgroup.customer.config.http.mvc.converter.LocalDateTimeConverter;
import com.google.common.collect.Lists;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.nio.charset.StandardCharsets;
import java.util.List;

@Configuration
public class WebMvcConfigure extends WebMvcConfigurerAdapter {

    @Override
    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        super.configureMessageConverters(converters);
        StringHttpMessageConverter stringConverter =
                new StringHttpMessageConverter(StandardCharsets.UTF_8);
        stringConverter.setSupportedMediaTypes(Lists.newArrayList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON, MediaType.TEXT_PLAIN));
        stringConverter.setWriteAcceptCharset(true);
        converters.add(stringConverter);
    }


    @Override
    public void addInterceptors(InterceptorRegistry registry) {
    }


    //添加枚举参数转化器
    //LocalDate,LocalDateTime转换器也在此添加
    @Override
    public void addFormatters(FormatterRegistry registry) {
        registry.addConverterFactory(new IEnumConverterFactory());
        registry.addConverter(new LocalDateConverter("yyyy-MM-dd"));
        registry.addConverter(new LocalDateTimeConverter("yyyy-MM-dd HH:mm:ss.SSS"));
        registry.addConverter(new DateConverter());
    }
}
