package cn.quantgroup.customer.config.http.security;

import cn.quantgroup.customer.constant.Constant;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.web.http.CookieHttpSessionStrategy;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.session.web.http.HttpSessionStrategy;


@EnableRedisHttpSession(maxInactiveIntervalInSeconds = Constant.COOKIE_AND_SESSION_EXPIRE_TIMEOUT_SECONDS, redisNamespace = Constant.CUSTOMER_SESSION_NAMESPACE)
public class WebSessionConfig {
    @Bean(name = "httpSessionStrategy")
    public HttpSessionStrategy httpSessionStrategy(@Qualifier("cookieSerializer") CookieSerializer cookieSerializer) {
        CookieHttpSessionStrategy strategy = new CookieHttpSessionStrategy();
        strategy.setCookieSerializer(cookieSerializer);
        return strategy;
    }

    @Bean(name = "cookieSerializer")
    public CookieSerializer generateCookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName(Constant.COOKIE_NAME);
        serializer.setCookiePath("/");
        serializer.setDomainNamePattern("^.+?.(\\w+.[a-z]+)$");
        serializer.setCookieMaxAge(Constant.COOKIE_AND_SESSION_EXPIRE_TIMEOUT_SECONDS);
        return serializer;
    }

}
