package cn.quantgroup.customer.config.http.security;

import cn.quantgroup.customer.constant.Constant;
import cn.quantgroup.customer.service.IUserService;
import cn.quantgroup.customer.util.PwdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsUtils;


@EnableWebSecurity
@EnableGlobalMethodSecurity(securedEnabled = true, prePostEnabled = true, jsr250Enabled = true)
public class WebSecurityConfig extends WebSecurityConfigurerAdapter {
    private final IUserService userService;

    @Autowired
    public WebSecurityConfig(IUserService userService) {
        this.userService = userService;
    }


    @Override
    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable()
                .authorizeRequests()
                .antMatchers("/tech/health/check").permitAll()
                .antMatchers("/login").permitAll()
                .antMatchers("/logout-success").permitAll()
                .anyRequest().authenticated()
                .requestMatchers(CorsUtils::isPreFlightRequest).permitAll()
                .and().sessionManagement().maximumSessions(1).maxSessionsPreventsLogin(true)
                .and().and().logout().invalidateHttpSession(true).clearAuthentication(true)
                .logoutSuccessUrl("/logout-success").deleteCookies(Constant.COOKIE_NAME)
                .and();
    }

    @Override
    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(userService).passwordEncoder(new PasswordEncoder() {
            @Override
            public String encode(CharSequence rawPass) {
                return PwdUtil.MD5(rawPass.toString().toLowerCase() + Constant.PASSWORD_SALT);
            }

            @Override
            public boolean matches(CharSequence rawPass, String password) {
                if (StringUtils.isEmpty(password)) {
                    return false;
                }
                return password.equals(PwdUtil.MD5(rawPass.toString().toLowerCase() + Constant.PASSWORD_SALT));
            }
        });
    }

    @Bean
    public HttpSessionEventPublisher httpSessionEventPublisher() {
        return new HttpSessionEventPublisher();
    }

}
