package cn.quantgroup.customer;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;

@Configuration
@EnableAspectJAutoProxy
@EnableRedisHttpSession(maxInactiveIntervalInSeconds = 24 * 60 * 60)
@SpringBootApplication(scanBasePackages = {
        "cn.quantgroup.customer"
})
public class Bootstrap {

    public static void main(String[] args) {
        SpringApplication.run(Bootstrap.class, args);
    }

}
