package cn.quantgroup.customer.entity;

import lombok.*;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "offline_repay_operate_record")
@ToString
@Builder
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@DynamicUpdate
@DynamicInsert
public class OfflineRepayOperateRecord implements Serializable {

    private static final long serialVersionUID = -9206318459421433518L;
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "serial_no")
    private String serialNo;
    @Column(name = "operate_account")
    private String operateAccount;
    @Column(name = "operate_name")
    private String operateName;
    @Column(name = "operate_content")
    private String operateContent;
    @Column(name = "operate_time")
    private LocalDateTime operateTime;
    @Column(name = "remark")
    private String remark;
    @Column(name = "create_time")
    private LocalDateTime createTime;
    @Column(name = "update_time")
    private LocalDateTime updateTime;
}
