package cn.quantgroup.customer.model.order;

import cn.quantgroup.customer.util.MoneySerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
@Data
public class BaitRepayPlan {
    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal principle;//应还本金

    private Integer termNo;//期数

    private Integer orderId;//订单id

    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal interest;//利息

    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal penaltyInterest;//逾期罚息

    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal redPacketAmount;//

    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal collectionReduction;//减免金额

    private Integer repaymentStatus;//还款状态

    private String repaymentStatusDesc;//还款状态描述

    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal repayAmount;//应还金额

    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal serviceAmount;//

    private String deadline;//还款期限

    private String repaidAt;//还款时间

}
