package cn.quantgroup.customer.config.data;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
//@EnableJpaRepositories(basePackages = "cn.quantgroup.customer.repo")
//@EnableTransactionManagement
public class DbConfig {

    @Value("${data.mysql.jdbc-url}")
    private String jdbcUrl;

    @Value("${data.mysql.password}")
    private String password;

    @Value("${data.mysql.user}")
    private String user;


    @Value("${data.mysql.secondary.jdbc-url}")
    private String jdbcUrlSecondary;

    @Value("${data.mysql.secondary.password}")
    private String passwordSecondary;

    @Value("${data.mysql.secondary.user}")
    private String userSecondary;


    @Value("${data.mysql.max-pool-size}")
    private Integer maxPoolSize;

    private String driverClassName ="com.mysql.jdbc.Driver";


    @Bean(name = "primaryDataSource")
    @Primary
    public DataSource primaryDataSource() {
        return DataSourceBuilder.create().url(jdbcUrl).username(user).password(password)
            .driverClassName(driverClassName).build();
    }

    @Bean(name = "secondaryDataSource")
    public DataSource secondaryDataSource() {
        return DataSourceBuilder.create().url(jdbcUrlSecondary).username(userSecondary).
            password(passwordSecondary).driverClassName(driverClassName).build();
    }

//    @Bean
//    @DependsOn(value = "dataSource")
//    public EntityManagerFactory entityManagerFactory(DataSource dataSource) {
//        LocalContainerEntityManagerFactoryBean entityManager = new LocalContainerEntityManagerFactoryBean();
//        entityManager.setDataSource(dataSource);
//        entityManager.setPackagesToScan("cn.quantgroup.customer");
//        entityManager.setPersistenceUnitName("dataSource");
//        Properties properties = new Properties();
//        properties.put("hibernate.jdbc.batch_size", 30);
//        properties.put("hibernate.order_inserts", true);
//        properties.put("hibernate.order_updates", true);
//        entityManager.setJpaProperties(properties);
//        entityManager.setJpaVendorAdapter(jpaVendorAdapter());
//        entityManager.afterPropertiesSet();
//        return entityManager.getObject();
//    }

//    @Bean
//    @Primary
//    public DataSource dataSource() {
//        HikariConfig config = new HikariConfig();
//        config.setJdbcUrl(jdbcUrl);
//        config.setPassword(password);
//        config.setUsername(user);
//        config.setMaximumPoolSize(maxPoolSize);
//        config.setMinimumIdle(20);
//        config.addDataSourceProperty("cachePrepStmts", "true");
//        config.addDataSourceProperty("prepStmtCacheSize", "250");
//        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
//        return new HikariDataSource(config);
//
//    }


//    private JpaVendorAdapter jpaVendorAdapter() {
//        HibernateJpaVendorAdapter hibernateJpaVendorAdapter = new HibernateJpaVendorAdapter();
//        hibernateJpaVendorAdapter.setShowSql(false);
//        hibernateJpaVendorAdapter.setGenerateDdl(false);
//        hibernateJpaVendorAdapter.setDatabase(Database.MYSQL);
//        return hibernateJpaVendorAdapter;
//    }
//
//    @Bean
//    public PlatformTransactionManager transactionManager(EntityManagerFactory entityManagerFactory) {
//        JpaTransactionManager transactionManager = new JpaTransactionManager();
//        transactionManager.setEntityManagerFactory(entityManagerFactory);
//        return transactionManager;
//    }

}
