package cn.quantgroup.customer.service;

import cn.quantgroup.customer.model.order.*;
import cn.quantgroup.customer.rest.param.card.ModifyReservePhone;
import cn.quantgroup.customer.rest.param.card.UnBindCardModel;
import cn.quantgroup.customer.rest.param.applyorder.ApplyOrderQuery;
import cn.quantgroup.customer.rest.param.ordermapping.EarlySettleUpOrderQueryParam;
import cn.quantgroup.customer.rest.param.ordermapping.OperateEntryParam;
import cn.quantgroup.customer.rest.param.ordermapping.OrderQueryParam;
import cn.quantgroup.customer.rest.param.repay.RepayOrderInfoQuery;
import cn.quantgroup.customer.rest.param.repay.RepayOrderQuery;
import cn.quantgroup.customer.rest.vo.JsonResult;

import java.util.List;

public interface IXyqbService {
    String findRepayOrders(RepayOrderQuery repayOrderQuery);


    /**
     * 申请订单列表查询
     * @param applyOrderQuery
     * @return
     */
    JsonResult<List<ApplyOrder>> findApplyOrders(ApplyOrderQuery applyOrderQuery);

    /**
     * 流程日志查看
     * @param orderNo 申请订单号
     * @return
     */
    JsonResult<List<FlowNode>> findFlowChart(String orderNo);


    /**
     * 提现订单查询
     * @param loanId
     * @return
     */
    JsonResult<LoanOrder> findLoanOrder(Long loanId);

    /**
     * 还款计划
     * @param loanId
     * @return
     */
    JsonResult<OrderRepayment> repaymentPlanQuery(Long loanId);

    String queryCardLists(Long userId);

    String queryCardRelation(Long bankId);

    String unBindCardRelation(UnBindCardModel unBindCardModel);

    String modifyReservePhone(ModifyReservePhone modifyReservePhone);

    String queryRepayInfo(RepayOrderInfoQuery repayOrderQuery);

    String queryRepayOptRecords(String businessFlowNo);

    /**
     * 订单状态查询
     *
     * @param orderQuery
     * @return
     */
    JsonResult<OrderStatus> orderStatusQuery(OrderQueryParam orderQuery);

    /**
     * 查询xyqb一次性结清订单相关信息
     *
     * @param orderQuery
     * @return
     */
    JsonResult<List<EarlySettleUpOrder>> findLoanOrder4EarlySettleUp(EarlySettleUpOrderQueryParam orderQuery);

    /**
     * 处理新增或删除白名单操作
     *
     * @param operateEntryParam
     * @return
     */
    JsonResult<Boolean> setOrCancelSettleUpWhiteList(OperateEntryParam operateEntryParam);

    /**
     * 提前一次性结清金额试算
     *
     * @param loanId
     * @return
     */
    JsonResult<EarlySettleUpTrial> earlySettleUpTrial(Long loanId);
}
