package cn.quantgroup.customer.rest.enums.phone;

public enum ModifyPhoneProcessingStatus {
    INIT("0", "待人工处理"),
    WAIT_4_USER_FEEDBACK("1", "待用户反馈结果"),
    DONE("2", "已反馈"),
    ;


    private String message;
    private String code;

    ModifyPhoneProcessingStatus(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getMessage() {
        return message;
    }

    public String getCode() {
        return code;
    }

    public static boolean validate(String code) {
        if (!INIT.code.equals(code) && !DONE.code.equals(code) && !WAIT_4_USER_FEEDBACK.code.equals(code)) {
            return false;
        }
        return true;
    }
}
