package cn.quantgroup.customer.config.http.mvc.converter;

import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;

import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;

public class IEnumConverterFactory implements ConverterFactory<String, IEnumValue> {
    private static final Map<Class, Converter> CONVERTER_MAP = new WeakHashMap<>();

    @Override
    public <T extends IEnumValue> Converter<String, T> getConverter(Class<T> targetType) {
        Converter result = CONVERTER_MAP.get(targetType);
        if (Objects.isNull(result)) {
            result = new IEnumConverter<>(targetType);
            CONVERTER_MAP.put(targetType, result);
        }
        return result;
    }
}
