package cn.quantgroup.customer.config.http.mvc.converter;

import org.springframework.core.convert.converter.Converter;


public class IEnumConverter<T extends IEnumValue> implements Converter<String, T> {
    private final Class<T> enumType;

    IEnumConverter(Class<T> enumType) {
        this.enumType = enumType;
    }

    @Override
    public T convert(String s) {
        T t;
        try {
            t = IEnumValue.parse(Integer.parseInt(s), enumType);
        } catch (NumberFormatException e) {
            t = IEnumValue.parseByName(s, enumType);
        }
        return t;
    }
}
