package cn.quantgroup.customer.util;

import org.apache.commons.lang3.StringUtils;

/**
 * 脱敏工具类
 *
 * @author Wang Xiangwei
 * @version 2020/3/18
 */
public class DesensitizeUtil {
    /**
     * 保留前面几位
     *
     * @param str
     * @param index
     * @return
     */
    public static String left(String str, int index) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        String name = StringUtils.left(str, index);
        return StringUtils.rightPad(name, StringUtils.length(str), "*");
    }

    /**
     * 前面保留 index 位明文，后面保留 end 位明文,如：[身份证号] 110****58，前面保留3位明文，后面保留2位明文
     *
     * @param str
     * @param index
     * @param end
     * @return
     */
    public static String around(String str, int index, int end) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        return StringUtils.left(str, index).concat(StringUtils.removeStart(StringUtils.leftPad(StringUtils.right(str, end), StringUtils.length(str), "*"), "***"));
    }

    /**
     * 保留后面几位 如手机号 *******5678
     *
     * @param str
     * @param end
     * @return
     */
    public static String right(String str, int end) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        return StringUtils.leftPad(StringUtils.right(str, end), StringUtils.length(str), "*");
    }


    public static String phoneMark(String phoneNo) {
        if (StringUtils.isNotBlank(phoneNo)) {
            String start = StringUtils.substring(phoneNo, 0, 3);
            String end = StringUtils.substring(phoneNo, phoneNo.length() - 4, phoneNo.length());
            return start.concat("****").concat(end);
        }
        return "";
    }

    public static String idNoMark(String idNo){
        if(StringUtils.isBlank(idNo)){
            return "";
        }

        if(idNo.length() == 18){
            return around(idNo,6,4);
        }

        if(idNo.length() == 15){
            return around(idNo,6,3);
        }

        return right(idNo,4);
    }
}
