package cn.quantgroup.customer.service;

import cn.quantgroup.customer.model.order.ApplyOrder;
import cn.quantgroup.customer.model.order.FlowNode;
import cn.quantgroup.customer.model.order.LoanOrder;
import cn.quantgroup.customer.model.order.SettleStatus;
import cn.quantgroup.customer.rest.param.applyorder.ApplyOrderQuery;
import cn.quantgroup.customer.rest.vo.JsonResult;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

public interface IIceService {
    JsonResult<ApplyOrder> findApplyOrders(ApplyOrderQuery applyOrderQuery);
    JsonResult<LoanOrder> findLoanOrder(Long loanId);
    JsonResult<List<FlowNode>> findFlowChart(String orderNo);

    JsonResult<List<SettleStatus>> findSettleFlag(List<Long> loanIds);

    JsonResult applySettle(Long loanId);

    JsonResult downloadSettle(HttpServletResponse response, Long loanId);

    JsonResult<ApplyOrder> findUserCashApplyOrders(ApplyOrderQuery applyOrderQuery);
}
