package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.rest.param.user.UserCombinationParam;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IUserService;
import cn.quantgroup.customer.service.IXyqbService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/user")
public class UserCashRest {

    private final IUserService userService;
    @Autowired
    public UserCashRest(IUserService userService) {
        this.userService = userService;
    }
    /**
     * 用户提现信息查询
     * @param combinationParam
     * @return
     */
    @GetMapping(value = "/cashInfo")
    public JsonResult findUserCombination(UserCombinationParam combinationParam) {
        return userService.findUserCashCombination(combinationParam);
    }
}
