package cn.quantgroup.customer.moice.vo;
import cn.quantgroup.customer.enums.AssignStatusEnum;
import cn.quantgroup.customer.moice.enums.LoanProgress;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Jie.Feng
 * @since 2020-04-25
 */
public class StatusMap {

    /**
     * 默认的显示
     */
    public static final String DEFAULT_STATUS = "-";

    public static String mapApplyStatus(AssignStatusEnum assignStatus) {
        switch (assignStatus) {
            case USER_CANCEL:
                return "取消借款";
            case ASSIGN_SUCC:
                return "风审通过";
            case ASSIGN_FAIL:
                return "资方审核失败";
            default:
                return "资方审核中";
        }
    }

    public static String mapLoanStatus(LoanProgress progress) {
        switch (progress) {
            case CHECK_REPAYMENT_PLAN:
                return "放款成功";
            case LOAN_COMPLETE:
                return "已结清";
            case WAITING_FUND:
            case FINAL_SENDED_TO_FUNDING_CORP:
            case START_ORDER:
            case PLACE_HOLDER_71:
                return "放款中";
            case WAITING_WITHDRAW:
                return "等待存管二次提现";
            case PLACE_HOLDER_70:
                return "等待二类户提现";
            case DROP_SUCC:
            case QUIT_AND_SHOW_REASON:
                return "取消借款";
            case FINAL_MASHANG_APPROVAL_FAIL:
                return "放款失败";
            case FINAL_SCREENING_REJECT:
                return "风控拒绝";
            default:
                return DEFAULT_STATUS;
        }
    }


    public static boolean invalidOrder(String ... statusDesc){
        for (String desc : statusDesc) {
            if(StringUtils.containsAny(desc, "拒绝", "取消", "关单", "失败")){
                return true;
            }
        }
        return false;
    }
}
