package cn.quantgroup.customer.moice.model;

import lombok.ToString;

import javax.persistence.*;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * Created by FrankChow on 15/10/28.
 */
@ToString
@Entity
@Table(name = "repayment_plan")
public class XyqbRepaymentPlan {
    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "loan_application_manifest_history_id")
    private Long loanApplicationManifestHistoryId;

    @Column(name = "loan_application_history_id")
    private Long loanApplicationHistoryId;

    @Column(name = "transaction_flow_id")
    private Long transcationFlowId;

    @Column(name = "term_no")
    private Integer termNo;

    @Column(name = "deadline")
    private Timestamp deadline;

    @Column(name = "current_repayment")
    private BigDecimal currentRepayment;

    @Column(name = "required_repayment")
    private BigDecimal requiredRepayment;

    @Column(name = "repayment_status")
    private Integer repaymentStatus;  //还款状态：0-未还款，1-还款中，2-已逾期，3-已还款

    @Column(name = "repaid_at")
    private Timestamp repaidAt;

    @Column(name = "repayment_received_at")
    private Timestamp repaymentReceivedAt;

    @Column(name = "remark")
    private String remark;

    //创建时间
    @Column(name = "created_at")
    private Timestamp createdAt;

    @Column(name = "updated_at")
    private Timestamp updatedAt;

    @Column(name = "pay_center_order_no")
    private String payCenterOrderNo = "";
    /**
     * 催收减免
     */
    @Column(name = "collection_relief")
    private BigDecimal collectionRelief;


    public Timestamp getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    public Timestamp getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Timestamp updatedAt) {
        this.updatedAt = updatedAt;
    }


    public String getPayCenterOrderNo() {
        return payCenterOrderNo;
    }

    public void setPayCenterOrderNo(String payCenterOrderNo) {
        this.payCenterOrderNo = payCenterOrderNo;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Timestamp getRepaymentReceivedAt() {
        return repaymentReceivedAt;
    }

    public void setRepaymentReceivedAt(Timestamp repaymentReceivedAt) {
        this.repaymentReceivedAt = repaymentReceivedAt;
    }

    public Timestamp getRepaidAt() {
        return repaidAt;
    }

    public void setRepaidAt(Timestamp repaidAt) {
        this.repaidAt = repaidAt;
    }

    public Integer getRepaymentStatus() {
        return repaymentStatus;
    }

    public void setRepaymentStatus(Integer repaymentStatus) {
        this.repaymentStatus = repaymentStatus;
    }

    public BigDecimal getRequiredRepayment() {
        return requiredRepayment;
    }

    public void setRequiredRepayment(BigDecimal requiredRepayment) {
        this.requiredRepayment = requiredRepayment;
    }

    public BigDecimal getCurrentRepayment() {
        return currentRepayment;
    }

    public void setCurrentRepayment(BigDecimal currentRepayment) {
        this.currentRepayment = currentRepayment;
    }

    public Timestamp getDeadline() {
        return deadline;
    }

    public void setDeadline(Timestamp deadline) {
        this.deadline = deadline;
    }

    public Integer getTermNo() {
        return termNo;
    }

    public void setTermNo(Integer termNo) {
        this.termNo = termNo;
    }

    public Long getTranscationFlowId() {
        return transcationFlowId;
    }

    public void setTranscationFlowId(Long transcationFlowId) {
        this.transcationFlowId = transcationFlowId;
    }

    public Long getLoanApplicationHistoryId() {
        return loanApplicationHistoryId;
    }

    public void setLoanApplicationHistoryId(Long loanApplicationHistoryId) {
        this.loanApplicationHistoryId = loanApplicationHistoryId;
    }

    public Long getLoanApplicationManifestHistoryId() {
        return loanApplicationManifestHistoryId;
    }

    public void setLoanApplicationManifestHistoryId(Long loanApplicationManifestHistoryId) {
        this.loanApplicationManifestHistoryId = loanApplicationManifestHistoryId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getCollectionRelief() {
        return collectionRelief;
    }

    public void setCollectionRelief(BigDecimal collectionRelief) {
        this.collectionRelief = collectionRelief;
    }

    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
