package cn.quantgroup.customer.moice.enums;

/**
 * Created by root on 15-8-1.
 */
public enum TransactionStatus {

    // 0 审核成功
    AUDIT_SUCCESS("审批成功"),
    // 1 已提交给资金方
    SUBMIT_FOR_FUND("已提交给资金方"),
    // 2, 资金方已放款, 从资金方反馈数据得到
    PAY_SUCCESS("已打款"),
    // 3, 放款未到账
    PAY_ERROR("未到账"),
    // 4, 资金方尝试放款失败
    PAY_FAIL("打款失败"),
    // 5, 用户已还款
    REPAY_SUCESS("已还款");

    private String description;

    TransactionStatus(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return "TransactionStatus{" +
                "description='" + description + '\'' +
                '}';
    }
}
