package cn.quantgroup.customer.model.order;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 还款计划信息
 * @author Wang Xiangwei
 * @version 2020/3/9
 */
@Data
public class Repayment {

    /**
     *还款期数
     */
    private Integer termNo;

    /**
     *本金
     */
    private BigDecimal principal;

    /**
     *利息
     */
    private BigDecimal interest;

    /**
     *担保费
     */
    private BigDecimal premium;

    /**
     *其他担保
     */
    private BigDecimal otherFee;

    /**
     *罚息
     */
    private BigDecimal overdueInterest;

    /**
     *逾期保费
     */
    private BigDecimal overdueServiceFee;

    /**
     *当前减免
     */
    private BigDecimal collectionRelief;

    /**
     *还款总额
     */
    private BigDecimal actualRepayment;

    /**
     *应还总额
     */
    private BigDecimal shouldAmount;

    /**
     *应还时间
     */
    private String shouldAt;

    /**
     *还款时间
     */
    private String repaymentReceivedAt;

    /**
     *还款状态
     */
    private String repaymentStatus;

    /**
     *还款方式
     */
    private String repayType;

    /**
     *逾期天数
     */
    private Integer overdueDays;
}
