package cn.quantgroup.customer.config.http.mvc.converter;


public interface IEnumValue {
    static <T extends IEnumValue> T parse(int code, Class<T> clazz) {
        T[] all = clazz.getEnumConstants();
        for (T current : all) {
            if (current.getValue() == code) {
                return current;
            }
        }
        throw new IllegalArgumentException("No element matches " + code);
    }

    static <T extends IEnumValue> T parseByName(String name, Class<T> clazz) {
        T[] all = clazz.getEnumConstants();
        for (T current : all) {
            if (current.toString().equals(name)) {
                return current;
            }
        }
        throw new IllegalArgumentException("No element matches " + name);
    }

    int getValue();
}
