package cn.quantgroup.customer.config.http.mvc.filter;

import cn.quantgroup.customer.config.container.UserThreadLocal;
import cn.quantgroup.customer.entity.OpUser;
import cn.quantgroup.customer.enums.ErrorCodeEnum;
import cn.quantgroup.customer.exception.BusinessException;
import cn.quantgroup.customer.exception.ValidTokenException;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IOpSystemService;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Objects;

/**
 * @author yangjun
 * @Date 2020/4/17 16:02
 * @Desc 鉴权过滤器
 * @Update
 */
@WebFilter(filterName = "operatePermitFilter",urlPatterns = {"/operate/sys/"})
@Slf4j
@Component
public class ValidOperatePermitFilter implements Filter {
    @Autowired
    private IOpSystemService IOpSystemService;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @SneakyThrows
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) servletRequest;

        if (HttpMethod.OPTIONS.toString().equals(request.getMethod())) {
            log.info("OPTIONS请求，放行");
            return;
        }

        String token = request.getHeader("x-auth-token");
        String system = request.getHeader("x-auth-system");
        if (StringUtils.isAnyBlank(token, system)) {
            log.error("缺少token信息,拦截");
            throw new ValidTokenException(ErrorCodeEnum.NO_TOKEN);
        }

        JsonResult<OpUser> opUserResult = IOpSystemService.findUserByToken(token, system);
        if (Objects.isNull(opUserResult) || !opUserResult.isSuccess()) {
            log.error("根据token查询不到用户信息 token:{}", token);
            throw new ValidTokenException(ErrorCodeEnum.ILLEGAL_TOKEN);
        } else {
            OpUser opUser = opUserResult.getData();
            UserThreadLocal.set(opUser);
        }

        //执行
        filterChain.doFilter(servletRequest, servletResponse);
    }

    @Override
    public void destroy() {

    }
}
