package cn.quantgroup.customer.config.data;

import cn.hutool.log.Log;
import javax.annotation.Resource;
import javax.sql.DataSource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class DatabaseConnectionKeeper {

    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public DatabaseConnectionKeeper(@Qualifier("secondaryDataSource") DataSource secondaryDataSource) {
        this.jdbcTemplate = new JdbcTemplate(secondaryDataSource);
    }

    // 每小时执行一次查询操作，保持数据库连接活跃
    @Scheduled(fixedDelay = 60000) // 每小时执行一次
    public void keepDatabaseConnectionAlive() {
        log.info("数据库定时任务执行");
        try {
            jdbcTemplate.execute("SELECT 1"); // 执行一个简单的查询操作
        } catch (Exception ex) {
            // 处理异常
            log.error("数据库定时任务执行异常",ex);
        }
    }
}