package cn.quantgroup.customer.model.order;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @description: 还款计划相关model
 * @author:tao
 * @create: 2020-02-19 11:07
 */
@Data
public class OrderRepayment {


    private Long loanId;

    /**
     * 放款总金额
     */
    private BigDecimal totalLoanAmount;

    /**
     * 收款总金额
     */
    private BigDecimal totalReceiveAmount;

    /**
     * 放款到账时间
     */
    private Long lendTime;

    /**
     * 申请时间,loan的created_at就行，提现签约时间
     */
    private Long applyTime;

    /**
     * 应还款总金额
     */
    private BigDecimal totalRepaymentAmount;

    /**
     * 总利息
     */
    private BigDecimal totalInterest;

    /**
     * 应还总服务费
     */
    private BigDecimal totalServiceFee;

    /**
     * 应还总其他费用
     */
    private BigDecimal totalOtherFee;
    /**
     * 已还 总
     */
    private BigDecimal alreadyPaidAmount;

    /**
     * 剩余未还 总
     */
    private BigDecimal notPaidAmount;

    /**
     * 已还n期
     */
    private Integer sumPaidTerm;

    /**
     * 是否结清 true 结清
     */
    private Boolean hasAllPaid;

    /** 还款计划 */
    private List<RepaymentPlanItem> repaymentPlans;

    /** 白条还款计划 */
    private List<BaitRepaymentPlanItem> baitRepaymentPlans;
}
