package cn.quantgroup.third.customer.entity;


import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Entity
@Table(name = "lhpds_workflow_process_instance_task_assignee")
@ToString
@Builder
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class WorkflowProcessInstanceTaskAssignee {
    @Id
    @Column(name = "process_instance_id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    // 流程实例id
    private String processInstanceId;

    // 任务id
    @Column(name = "task_id")
    private String taskId;

    // 受理人
    @Column(name = "assignee")
    private String assignee;

    // 任务状态
    @Column(name = "task_state")
    private String taskState;

    // 任务名称
    @Column(name = "task_name")
    private String taskName;
    // 状态
    @Column(name = "state")
    private int state;
}
