package cn.quantgroup.customer.util;

import org.apache.commons.lang3.StringUtils;

public class MaskingUtil {

    /**
     * 对姓名进行掩码处理，只显示第一个字，其余用 * 号替换。
     * 例如：张三 -> 张**
     *
     * @param name 姓名
     * @return 掩码后的姓名
     */
    public static String maskName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        // 姓名只显示第一个字
        return name.charAt(0) + "**";
    }

    /**
     * 对手机号进行掩码处理，只显示前三位和后四位，其余用 * 号替换。
     * 例如：13812345678 -> 138****5678
     *
     * @param phoneNumber 手机号
     * @return 掩码后的手机号
     */
    public static String maskPhoneNumber(String phoneNumber) {
        if (StringUtils.isEmpty(phoneNumber) || phoneNumber.length() < 7) {
            return phoneNumber;
        }
        return phoneNumber.substring(0,3) + "****" + phoneNumber.substring(7);
    }

    /**
     * 对收货地址进行掩码处理，只显示前两个字，其余用 * 号替换。
     * 例如：广东省广州市天河区 -> 广东******
     *
     * @param address 收货地址
     * @return 掩码后的收货地址
     */
    public static String maskAddress(String address) {
        if (address == null || address.length() < 2) {
            return address;
        }
        return address.substring(0, 3) + "*********";
    }

}
