package cn.quantgroup.third.customer.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Entity
@Table(name = "lhpds_workflow_process_instance")
@ToString
@Builder
@Getter
@Setter
@AllArgsConstructor
public class WorkflowProcessInstance {
    @Id
    @Column(name = "process_instance_id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    // 主键
    private String processInstanceId;
    // 流程定义id
    private String processDefinitionId;
    // 子母工单状态,0-普通工单，1-母工单，2-子工单
    private Integer parentChildrenType;
    // 是否关闭，0-否，1-是
    private Integer isClosed;
    // 工单状态
    private String globalState;
    // 优先级
    private String priority;
    // 来源
    private String source;
    // 工单创建人
    private String createUser;
    // 工单创建时间
    private Date createTime;
    // 工单最后修改人
    private String modifiedUser;
    // 工单最后修改时间
    private Date modifiedTime;
    // 工单关闭人
    private String closeUser;
    // 工单关闭时间
    private Date closeTime;
    // 会话id
    private String sessionId;
    // 客户联系方式
    private String contact;
    // 业务分类id
    private String templateGroupId;
    // 业务类型id
    private String templateId;
    // 数据id
    private String dataId;
    // 排序id
    private String sortId;
    // 工单编号
    private String orderId;

    // Getters and setters for all fields
}
