package cn.quantgroup.customer.rest.enums.phone;

import org.apache.commons.lang3.StringUtils;

public enum ModifyPhoneAuditStatus {
    PASS("1", "通过"),
    REJECT("2", "不通过");


    public String getMessage() {
        return message;
    }


    public String getCode() {
        return code;
    }

    private String code;
    private String message;

    ModifyPhoneAuditStatus(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public static boolean validate(String code, String applyStatusReason) {
        if (!PASS.code.equals(code) && !REJECT.code.equals(code)) {
            return false;
        }
        if (REJECT.getCode().equals(code) && StringUtils.isEmpty(applyStatusReason)) {
            return false;
        }
        return true;
    }
}
