package cn.quantgroup.riskcontrol.model;


import cn.quantgroup.customer.entity.User;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.Collection;
import java.util.LinkedList;


public class AuthenticationUserDetail extends User implements UserDetails {

    private static final long serialVersionUID = 1L;

    public AuthenticationUserDetail(User user) {
        this.setUsername(user.getUsername());
        this.setId(user.getId());
        this.setRole(user.getRole());
        this.setCompanyId(user.getCompanyId());
        this.setName(user.getName());
        this.setPassword(user.getPassword());
        this.setEnable(user.isEnable());
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        Collection<GrantedAuthority> authorities = new LinkedList<>();
        authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        return authorities;
    }

    @Override
    public String getPassword() {
        return super.getPassword();
    }

    @Override
    public String getUsername() {
        return super.getUsername();
    }

    @Override
    public boolean isAccountNonExpired() {
        return true;
    }

    @Override
    public boolean isAccountNonLocked() {
        return true;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return isEnable();
    }
}
