package cn.quantgroup.customer.model.order;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @description: 还款计划明细
 * @author:tao
 * @create: 2020-02-19 11:15
 */

@Data
public class RepaymentPlanItem {

    /**
     * 期数
     */
    private Integer periodNo;
    /**
     * 还款类型 COMMON(正常)或SELF_WITHHOLD(代扣)
     */
    private String repaymentType;
    /**
     * 还款状态，0 ("未还款")、2 ("已逾期")、3 ("已还款")
     */
    private Integer repaymentStatus;
    /**
     * 应还本金
     */
    private BigDecimal principal;
    /**
     * 应还利息
     */
    private BigDecimal interest;
    /**
     * 应还罚息
     */
    private BigDecimal overdueInterest;
    /**
     * 应还服务费
     */
    private BigDecimal serviceFee;
    /**
     * 应还其它费用
     */
    private BigDecimal otherFee;
    /**
     * 最早可还款时间
     */
    private Long repayableTime;
    /**
     * 还款日期（到期时间），10位时间戳
     */
    private Long dueTime;
    /**
     * 应还金额
     */
    private BigDecimal requiredRepayment;
    /**
     * 实还本金
     */
    private BigDecimal actPrincipal;
    /**
     * 实还利息
     */
    private BigDecimal actInterest;
    /**
     * 实还服务费
     */
    private BigDecimal actServiceFee;
    /**
     * 实还罚息
     */
    private BigDecimal actOverdueInterest;
    /**
     * 实还其它费用
     */
    private BigDecimal actOtherFee;
    /**
     * 减免金额
     */
    private BigDecimal reliefAmount;
    /**
     * 实还金额
     */
    private BigDecimal repayAmount;
    /**
     * 逾期天数
     */
    private Integer overdueDays;
    /**
     * 还款时间
     */
    private Long repayTime;
}
