package cn.quantgroup.customer.repo;

import cn.quantgroup.customer.entity.OperateLogModel;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface OperateLogRepo extends JpaRepository<OperateLogModel, Long> {

    @Query(value = "select * from operate_log where loan_id =?1 and status = 1 ORDER BY id DESC", nativeQuery = true)
    List<OperateLogModel> findLogsByLoanId(Long loanId);

    @Query(value = "select count(1) from operate_log where loan_id =?1", nativeQuery = true)
    Long findLogsCountsByLoanId(Long loanId);
}
