package cn.quantgroup.customer.enums;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import lombok.Getter;

@Getter
public enum ProblemTypeEnum {

    PRODUCT_CONSULTATION(224, "商品咨询"),
    SHIPPING_CONSULTATION(225, "发货咨询"),
    REFUND_CONSULTATION(226, "退款咨询"),
    LOGISTICS_CONSULTATION(227, "物流咨询"),
    INVOICE_CONSULTATION(228, "发票咨询"),
    RESET_PASSWORD(253, "重置密码"),
    CANCEL_ACCOUNT(254, "注销账户"),
    PAYMENT_ISSUE(255, "支付问题"),
    MEMBERSHIP_CONSULTATION(257, "会员咨询"),
    CHANGE_PHONE_NUMBER(258, "修改手机号"),
    MERCHANT_REGISTRATION(259, "商家入驻"),
    SPECIAL_GROUP_CALL(260, "特殊人群来电"),
    //售前-其他
    PRE_SALE_OTHER(261, "其他"),
    REGISTER_ACCOUNT(269, "注册账号"),
    WALLET_ISSUE(294, "卡包问题"),
    TEST_USAGE(408, "测试使用"),


    /*售中*/
    URGE_SHIPMENT(231, "催促发货"),
    URGE_REFUND(232, "催退款"),
    NO_LOGISTICS_PROGRESS(233, "物流无进度"),
    CHANGE_ADDRESS(234, "更改地址"),
    //售中-其他
    MIDDLE_SALES_OTHER(235, "其他"),
    MIDDLE_SALES_PAYMENT_ISSUE(252, "支付问题"),
    LOGISTICS_INTERCEPTION_REJECTION(262, "物流拦截/拒收"),
    LOGISTICS_EXCEPTION(263, "物流异常"),
    CONSULT_SHIPMENT_TIMELINESS(266, "咨询发货时效"),
    CANCEL_ORDER(267, "取消订单"),
    GIFT_CARD_CONSULTATION(384, "礼品卡咨询"),
    EXCHANGE_GOODS(388, "换货"),
    URGE_SHIPMENT_WITHIN_48H(391, "48H内催促发货"),
    URGE_SHIPMENT_BEYOND_48H(392, "超48H催促发货"),
    URGE_SHIPMENT_WITHIN_72H(393, "72H内催促发货"),
    URGE_SHIPMENT_BEYOND_72H(394, "超72H催促发货"),
    URGE_COLLECTION(395, "催揽收（催促发货）"),
    URGE_CANCEL_ORDER_REVIEW_WITHIN_TIMELINESS(396, "时效内催取消订单审核"),
    URGE_CANCEL_ORDER_REVIEW_BEYOND_TIMELINESS(397, "超时催取消订单审核"),
    URGE_REFUND_REVIEW_WITHIN_TIMELINESS(400, "时效内催仅退款审核"),
    URGE_REFUND_REVIEW_BEYOND_TIMELINESS(401, "超时催仅退款审核"),

    /*售后*/
    RETURN_REFUND(237, "退货退款"),
    PRODUCT_QUALITY_ISSUE(238, "商品质量问题"),
    SHORTAGE_IN_DELIVERY(239, "漏发/少发"),
    LOST_DAMAGED_ITEM(240, "丢件/破损"),
    SHIPPING_COST_REIMBURSEMENT(241, "补运费"),
    COMPENSATION(242, "赔付"),
    AFTER_SLAES_URGE_REFUND(243, "催退款"),
    AFTER_SLAES_INVOICE_CONSULTATION(249, "发票咨询"),
    OTHER(250, "其他"),
    INSTALLATION_ISSUE(251, "安装问题"),
    WRONG_ITEM_DELIVERED(264, "商品错发"),
    PRICING_ISSUE(265, "价格问题"),
    SUSPECTED_FAKE_PRODUCT(268, "质疑假货"),
    EXCHANGE_ISSUE(390, "换货问题"),
    URGE_AFTERSALES_REVIEW_WITHIN_TIMELINESS(399, "时效内催售后审核"),
    URGE_AFTERSALES_REVIEW_BEYOND_TIMELINESS(402, "超时催售后审核"),
    URGE_REFUND_REVIEW(403, "催退款审核"),
    MAX_MEMBER_REFUND(405, "MAX会员退费"),
    DIAMOND_MEMBER_REFUND(411, "钻石会员退费"),
    LOGISTICS_UPLOAD_ERROR(412, "物流上传错误"),
    TEST(410, "测试"),

    ;

    private final int code;
    private final String desc;

    public static Map<Integer, ProblemTypeEnum> codeEnumMap = Maps.newHashMap();

    ProblemTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        for (ProblemTypeEnum problemType : ProblemTypeEnum.values()) {
            codeEnumMap.put(problemType.getCode(),problemType);
        }
    }


    public static ProblemTypeEnum getByCode(Integer code) {
        if (code == null || code == 0) {
            return null;
        }
        ProblemTypeEnum problemType = codeEnumMap.get(code);
        if (Objects.nonNull(problemType)) {
            return problemType;
        }
        return null;
    }
}
