package cn.quantgroup.customer.config.data;

import cn.hutool.log.Log;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DatabaseConnectionKeeper {

    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public DatabaseConnectionKeeper(@Qualifier("secondaryDataSource") DataSource secondaryDataSource) {
        this.jdbcTemplate = new JdbcTemplate(secondaryDataSource);
    }

    // 每小时执行一次查询操作，保持数据库连接活跃
    @Scheduled(fixedDelay = 60000) // 每小时执行一次
    public void keepDatabaseConnectionAlive() {
        try {
            jdbcTemplate.execute("SELECT 1"); // 执行一个简单的查询操作
        } catch (Exception e) {
            // 处理异常
        }
    }
}