package cn.quantgroup.third.customer.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Entity
@Table(name = "lhpds_sys_user")
@ToString
@Builder
@Getter
@Setter
@AllArgsConstructor
public class LhpdsSysUser {
  @Id
  @Column(name = "id")
  @GeneratedValue(strategy = GenerationType.IDENTITY)
    // 用户编号
    private Long id;
    // 用户帐号
    private String accountId;
    // 用户昵称(在线字段)
    private String nickname;
    // 用户姓名
    private String username;
    // 用户密码
    private String password;
    // 盐值
    private String field11;
    private String salt;
    // 用户类型(1-普通用户 2-在线用户 3-坐席用户 4-在线+坐席)
    private Integer userType;
    // 用户等级(在线字段 取值1-5)
    private Integer level;
    // 创建时间
    private Date createTime;
    // 创建人员
    private String createUser;
    // 更新时间
    private Date updateTime;
    // 更新人员
    private String updateUser;
    // 是否首次登录(默认为0 0-首次登录 1-不是首次登录)
    private Integer isFirstLogin;
    // 错误密码次数(默认值为0)
    private Integer loginFailCount;
    // 登录超限锁定时间
    private Date loginLockingTime;
    // 最大同时会话量(在线字段 取值0-100)
    private Integer maxCurrentSessionCount;
    // 状态(默认为0，0-启用 1-禁用 2-删除)
    private Integer status;
    // 预留字段01 to field20
    private String field01;
    private String field02;
    private String field03;
    private String field04;
    private String field05;
    private String field06;
    private String field07;
    private String field08;
    private String field09;
    private String field10;
    private String field12;
    private String field13;
    private String field14;
    private String field15;
    private String field16;
    private String field17;
    private String field18;
    private String field19;
    private String field20;

    // Constructors, getters, and setters
}
