package cn.quantgroup.customer.service.impl;

import cn.quantgroup.customer.rest.param.thirdworkorder.WorkOrderParam;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.rest.vo.thirdworkorder.ThirdWorkOrderVo;
import cn.quantgroup.customer.service.IThirdWorkOrderService;
import cn.quantgroup.customer.service.IWorkOrderService;
import cn.quantgroup.third.customer.repo.LhpdsCustomer2Repo;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author:tao
 * @create: 2020-08-14 15:24
 */
@Slf4j
@Service
public class ThirdWorkOrderServiceImpl implements IThirdWorkOrderService {

    @Autowired
    private LhpdsCustomer2Repo customer2Repo;

    @Autowired
    @Qualifier("entityManagerSecondary")
    private EntityManager entityManager;
    @Override
    public JsonResult<Map<String,Object>> queryWorkOrder(WorkOrderParam param) {
        long offset =  (param.getPageNo()-1) * param.getPageSize();

        StringBuffer sql = new StringBuffer();
        sql.append("SELECT "
            + "lc.id,lc.create_user createUser,assignee.assignee acceptUser ,lc.field10 orderId,lc.field17 problemDesc,lwpi.process_instance_id processInstanceId,lwpi.priority priority,lwpi.global_state status "
            + "FROM lhpds_customer_2 lc  left join lhpds_workflow_process_instance lwpi on lc .id =lwpi.data_id "
            + "left join lhpds_workflow_process_instance_task_assignee assignee "
            + "on lwpi.process_instance_id = assignee.process_instance_id and assignee.task_name ='处理工单' and assignee.state =0 " );
        StringBuffer countSql = new StringBuffer();
        countSql.append("SELECT count(1)"
            + "FROM lhpds_customer_2 lc  left join lhpds_workflow_process_instance lwpi on lc .id =lwpi.data_id "
            + "left join lhpds_workflow_process_instance_task_assignee assignee "
            + "on lwpi.process_instance_id = assignee.process_instance_id and assignee.task_name ='处理工单' and assignee.state =0 " );

        StringBuffer conditionSql = new StringBuffer();
        if (param.getId()!=null){
            conditionSql.append("and lc.id="+param.getId());
        }
        if (StringUtils.isNotBlank(param.getOrderId())){
            conditionSql.append("and lc.field10="+param.getOrderId());
        }
        if (StringUtils.isNotBlank(param.getProcessInstanceId())){
            conditionSql.append("and lwpi.process_instance_id='"+param.getProcessInstanceId()+"'");
        }
        if (StringUtils.isNotBlank(param.getPriority())){
            conditionSql.append("and lwpi.priority='"+param.getPriority()+"'");
        }
        if (StringUtils.isNotBlank(param.getStatus())){
            conditionSql.append("and lwpi.global_state='"+param.getStatus()+"'");
        }
        if (StringUtils.isNotBlank(param.getCreateUser())){
            conditionSql.append("and lc.create_user='"+param.getCreateUser()+"'");
        }
        if (StringUtils.isNotBlank(param.getAcceptUser())){
            conditionSql.append("and assignee.assignee='"+param.getAcceptUser()+"'");
        }

        if (StringUtils.isNotBlank(conditionSql.toString())){
            sql.append(" where "+conditionSql.toString().substring(3));
            countSql.append(" where "+conditionSql.toString().substring(3));
        }
        sql.append( " limit "+offset+","+param.getPageSize());
        Query nativeQuery = entityManager.createNativeQuery(sql.toString());
        List<Object[]> result = nativeQuery.getResultList();
        Query countQuery = entityManager.createNativeQuery(countSql.toString());
        Object count = countQuery.getSingleResult();
        List<ThirdWorkOrderVo> resultList = new ArrayList<>();
        for (Object[] objects : result){
            ThirdWorkOrderVo vo = new ThirdWorkOrderVo();
            vo.setId(Long.parseLong(objects[0].toString()));
            if (objects[1] != null){
                vo.setCreateUser(objects[1].toString());
            }
            if (objects[2] != null){
                vo.setAcceptUser(String.valueOf(objects[2]));
            }
            if (objects[3] != null){
                vo.setOrderId(objects[3].toString());
            }

            if (objects[4] != null){
                vo.setProblemDesc(objects[4].toString());
            }
            if (objects[5] != null){
                vo.setProcessInstanceId(objects[5].toString());
            }
            if (objects[6] != null){
                vo.setPriority(objects[6].toString());
            }
            if (objects[7] != null){
                vo.setStatus(objects[7].toString());
            }
            resultList.add(vo);
        }

        Map<String,Object> map = new HashMap<>();
        map.put("total",Integer.parseInt(count.toString()));
        map.put("records",resultList);
        return JsonResult.buildSuccessResult("查询成功",map);
    }
}
