package cn.quantgroup.customer.enums;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 订单状态枚举
 */
@Getter
@AllArgsConstructor
public enum KdspOrderStatusEnum {
    /**
     * 待付款
     */
    WAITING_FOR_PAY(11, "待付款"),
    /**
     * 待发货
     */
    WAITING_FOR_DELIVERY(12, "待发货"),
    WAITING_FOR_RECEIVE(13, "待收货"),
    DELIVERYING_FOR_ORDER(14, "发货中"),
    /**
     * 订单完成
     */
    FINISH(21, "订单完成"),
    /**ei
     * 订单已付款主动取消
     */
    PAID_ORDER_CANCEL(31, "订单已付款主动取消"),
    /**
     * 只在拆单失败时，才会设置此状态，并且设置pay_status为5待退款
     */
    PAID_ORDER_AUTO_CANCEL(32, "订单已付款自动取消"),
    PAID_ORDER_REJECT_CANCEL(33, "订单拒收取消"),
    /**
     * 虚拟充值类订单已付款充值失败系统取消
     */
    PAID_VIRTUAL_RECHARGE_FAILED_CANCEL(36, "订单已付款充值失败取消"),

    PAID_ORDER_CANCEL_CLOSE(41, "订单已付款主动取消已退款订单关闭"),
    PAID_ORDER_AUTO_CANCEL_CLOSE(42, "订单已付款自动取消已退管订单关闭"),
    NOT_PAY_ORDER_CANCEL_CLOSE(43, "订单未支付主动取消订单关闭"),
    NOT_PAY_ORDER_TIMEOUT_CLOSE(44, "订单超时未支付订单关闭"),
    PAID_ORDER_REJECT_CANCEL_CLOSE(45, "订单拒收退款订单关闭"),
    /**
     * 虚拟充值类订单 已付款充值失败已退款订单关闭
     */
    PAID_VIRTUAL_RECHARGE_FAILED_CANCEL_CLOSE(46, "订单已付款充值失败已退款订单关闭"),
    SPLIT_ORDER_CLOSE(51, "订单拆单关闭"),
    ;

    private Integer value;
    private String desc;


    public static Map<Integer,KdspOrderStatusEnum> codeEnumMap = Maps.newHashMap();
    static {
        for (KdspOrderStatusEnum value : KdspOrderStatusEnum.values()) {
            codeEnumMap.put(value.getValue(),value);
        }
    }

    public Integer getValue() {
        return this.value;
    }

    public static KdspOrderStatusEnum getByCode(Integer status) {
        if (status == null || status == 0) {
            return null;
        }
        KdspOrderStatusEnum orderStatus = codeEnumMap.get(status);
        if (Objects.nonNull(orderStatus)) {
            return orderStatus;
        }
        return null;
    }
}
