package cn.quantgroup.customer.rest.param.transactionreceipt;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@ToString
@AllArgsConstructor
@NoArgsConstructor
public class TransactionReceiptRecordQuery {
    /**
     * 交易单号
     */
    private String orderNo;
    /**
     * 导入状态
     */
    private String importStatus;
    /**
     * 导出状态
     */
    private String exportStatus;
    /**
     * 当前页数
     */
    @NotNull(message = "当前页数不能为空")
    private Integer pageNo;
    /**
     * 每页多少条数据
     */
    @NotNull(message = "每页条数不能为空")
    private Integer pageSize;

    //更新成功list
    private List<String> successList;
    //签章成功数量
    private Integer successCount;
    //更新失败list
    private List<String> failList;
    //签章失败数量
    private Integer failCount;
}
